
markup.push(
{
	
	// MARK: script window

	ScriptsWindow:
	{
		nsClass: "GXWindow",
		gxWindowTitle: "Script Library",
		gxCanFullScreen: false,
		gxFullSizeContentView: true,
		gxWindowMaxSize: "2560, 2000",
		gxWindowMinSize: "600, 510",
		gxInitialWindowSize: "800, 510",
		gxInitialWindowPosition: "0.5, 0.22",
		gxBackColor: "BackColor1",
		gxSavedWindowStateKey: "scriptsWindow",
		gxContentView: "ScriptsWindowContentView"
	},


	// MARK: content view

	ScriptsWindowContentView:
	{
		nsClass: "GXDrawView",
		gxWantsLayer: true,
		gxLayout:
		[
			"V:|-0-[scriptArea]-0-[logArea(140)]-0-|",
			"V:|-0-[sidebarView]-0-|",

			"H:|-0-[sidebarView(250)]-0-[scriptArea]-0-|",
			"H:[sidebarView]-0-[logArea]-0-|",
		],
		gxChildViews:
		{
			windowTitle:
			{
				"+": "LabelView.foreColor1.size135",
				gxIntrinsicWidth: -1,
				gxLayout: [ "H:|-75-[self]-75-|", "V:|-6-[self]" ],
				axIsIgnored: true,
				gxDefaultValue: "Script Library",
			},
			sidebarView:
			{
				nsClass: "GXDrawView",
				axIsIgnored: false,
				axTitle: "Sidebar",
				axHelp: "Holds lists of Built-in and User scripts. Navigating to each script displays it in the window.",
				gxLayout:
				[
					"V:|-25-[sidebarTabs(62)]",
					"H:|-0-[sidebarTabs(250)]",

					"V:[sidebarTabs]-0-[userPanel]-0-|",
					"H:|-0-[userPanel(250)]",

					"V:[sidebarTabs]-0-[builtinPanel]-0-|",
					"H:|-0-[builtinPanel(250)]",
				],
				gxBackPainter: {
					nsClass: "GXPainter",
					gxEdgeInsets: "-2,0,-2,0",
					gxFrameColor: "SidebarBackColor2.pressed",
					gxFillColor: "SidebarBackColor2",
				},
				gxChildViews:
				{
					sidebarTabs: "ScriptsSidebarTabs",
					userPanel: {
						"+": "UserScriptsPanel",
					},
					builtinPanel: {
						"+": "BuiltinScriptsPanel",
					},
				},
			},
			scriptArea:
			{
				nsClass: "GXDrawView",
				gxBackPainter: fillPainter("SidebarBackColor1.noDisabled"),
				gxViewModel: {
					nsClass: "AH4ScriptViewModel",
					gxSharedViewModelID: "ScriptViewModel",
				},
				gxLayout:
				[
					"V:|-29-[scriptName(27)]-4-[errorText(20)]",
					"V:|-29-[builtinName(27)]",
					
					"V:|-86-[divider1(1)]-6-[scriptScrollView]-0-[dividerBar(30)]-0-|",

					"H:[infoBtn(105)]-14-|",
					"V:|-6-[infoBtn]",

					"H:|-14-[scriptName]-20-|",
					"H:|-18-[builtinName]-20-|",
					
					"H:|-0-[scriptScrollView]-3-|",

					"H:|-18-[requiresArgs(300)]",
					"V:[scriptName]-7-[requiresArgs]",

					"H:|-18-[errorText]-18-|",

					"H:|-0-[divider1]-0-|",
				],
				gxChildViews:
				{
					scriptName: {
						"+": "BaseTextField",
						gxValueKey: "name",
						axTitle: "Script name",
						axHelp: "VO press to edit the name of this script",
						gxEditingKeyPath: "editingTitle",
						gxTextPainter: { "+": "ControlFore", gxHAlign: 0, gxFontSize: 16 },
						gxEdgeInsets: "2, 4, 2, 3",
						//gxBackColor: "BackColor2",
						gxPencilForePainter: "PencilForePainter",
						gxPencilBackPainter: "PencilBackPainter",
						gxFocusRingPainter: "ControlBack",
						gxIntrinsicWidth: -1,
					},
					builtinName: {
						"+": "LabelView.left.centery.useMarkup.size16",
						axIsIgnored: false,
						axTitle: "Script name",
						axHelp: "Name of the selected built-in script",
						gxIntrinsicWidth: -1,
					},
					infoBtn: {
						"+": "ButtonView.useMarkup.size11",
						gxTitle: "<boldWeight>?</boldWeight> Scripting Help",
						gxIntrinsicHeight: 18,
					},
					divider1: filledView("SidebarBackColor2.pressed"),
					scriptScrollView:
					{
						nsClass: "GXScrollView",
						gxVScrollbar: "ScrollBarView",
						gxBackColor: "SidebarBackColor1.noDisabled",
						gxScrollbarWidth: 13,
						gxDocumentView:
						{
							"+": "DarkTextField",
							nsClass: "GXScriptTextView",
							gxViewName: "scriptText",
							gxTextPainter: {
								"+": "TextPainter",
								gxFontSize: "12.5",
								gxFontFamily: "SystemMono",
							},
							gxTextContainerInset: "6, 5",
							gxFrameRect: "0, 0, 584, 100",	// frame rect required. width is critical!
							axTitle: "Script",
							
							gxSyntaxNoneColor: "SyntaxNoneColor.noDisabled",
							gxSyntaxCommentColor: "SyntaxCommentColor.noDisabled",
							gxSyntaxQuoteColor: "SyntaxQuoteColor.noDisabled",
							gxSyntaxIdentifierColor: "SyntaxIdentifierColor.noDisabled",
							gxSyntaxFunctionColor: "SyntaxFunctionColor.noDisabled",
							gxSyntaxNumberColor: "SyntaxNumberColor.noDisabled",
							gxSyntaxRequiresColor: "SyntaxRequiresColor.noDisabled",
							gxSyntaxErrorColor: "SyntaxErrorColor.disabled",
						}
					},
					requiresArgs:
					{
						"+": "LabelView.useMarkup.size10.left",
						gxIntrinsicWidth: -1,
					},
					errorText:
					{
						"+": "LabelView",
						gxForePainter: {
							"+": "LabelFore.size14.left",
							gxFontColor: "SyntaxErrorColor",
						},
						gxIntrinsicWidth: -1,
					},
					dividerBar:
					{
						nsClass: "GXDrawView",
						//gxBackPainter: fillPainter("LCDBackColor2"),
						gxBackPainter: {
							nsClass: "GXPainter",
							gxEdgeInsets: "0, 0, -1, 0",
							gxFillColor: "SidebarBackColor2",
							gxFrameColor: "SidebarBackColor2.pressed",
						},
						gxLayout:
						[
							"H:|-0-[self]-0-|",
							
							"H:|-10-[logLabel(0)]-0-[runBtn(120)]-(>=10)-[clearBtn(75)]-14-|",

							"V:|-6-[logLabel]",
							"V:|-6-[clearBtn(18)]",
							"V:|-6-[runBtn(18)]",
						],
						gxChildViews:
						{
							logLabel: labelView("Log"),
							clearBtn: {
								"+": "ButtonView.centery.size115",
								gxValueKey: "clearBtnValue",
								gxTitle: "Clear Log",
							},
							runBtn: {
								"+": "ButtonView.useMarkup.centery.roundEnds",
								gxTitle: "<icon12.playbtn/><size115> Run Script Now",
							},
						}
					},
				},
			},
			logArea:
			{
				nsClass: "GXDrawView",
				gxBackPainter: fillPainter("SidebarBackColor1.noDisabled"),
				gxLayout:
				[
					"V:|-0-[logScrollView]-0-|",
					"H:|-0-[logScrollView]-3-|",
				],
				gxChildViews:
				{
					logScrollView:
					{
						nsClass: "GXScrollView",
						gxBackColor: "SidebarBackColor1.noDisabled",
						gxVScrollbar: "ScrollBarView",
						gxDocumentView: {
							"+": "DarkTextField",
							nsClass: "GXLogView",
							gxViewName: "logView",
							gxEditable: false,
							gxTextPainter: {
								"+": "TextPainter",
								gxFontSize: "11.5",
								gxFontFamily: "SystemMono",
							},
							gxTextContainerInset: "6, 5",
							gxFrameRect: "0, 0, 584, 100",	// frame rect required. width is critical!
							axTitle: "Log",
							gxValueKey: "freshLogText",
						}
					},
				},
			},
		}
	},


	// MARK: - user scripts panel
		
	UserScriptsPanel:
	{
		nsClass: "GXDrawView",
		axIsIgnored: true,
		gxShowOnKey: "tabShown",
		gxLayout:
		[
			"V:|-0-[scriptsListScrollView]-0-[bottomBar(45)]-0-|",

			"H:|-0-[scriptsListScrollView]-1-|",
			"H:|-0-[scriptsList]-0-|",
			"H:|-0-[bottomBar]-1-|",
		],
		gxChildViews:
		{
			scriptsListScrollView:
			{
				nsClass: "GXScrollView",
				gxBackColor: "SidebarBackColor2",
				gxVScrollbar: "ScrollBarView",	// vertical scroller only
				gxAddViewBelow: true,
				gxDocumentView:
				{
					nsClass: "GXListView",
					gxValueKey: "subModels",
					gxDeleteKey: "deleteScriptBtn",
					gxCopyValues: true,
					gxListItemView: "UserScriptListItem",
					gxViewName: "scriptsList",
					gxItemHeight: 34,
					gxInterItemHeight: 1,
					gxTopHeight: 5,
					gxBottomHeight: 6,
					axIsIgnored: false,
					axTitle: "User Scripts List",
					axHelp: "List of all user scripts"
				}
			},
			bottomBar:
			{
				nsClass: "GXDrawView",
				gxBackPainter: {
					nsClass: "GXPainter",
					gxEdgeInsets: "-1, 0, -1, -1",
					gxFillColor: "SidebarBackColor2",
					gxFrameColor: "SidebarBackColor2.pressed",
				},
				gxLayout: [
					"H:|-13-[newScriptBtn(98)]-(>=0)-[deleteBtn(25)]-13-|",
					"H:[self]-(<=0)-[newScriptBtn]&alignCenterY",	// center vertically
					"H:[self]-(<=0)-[deleteBtn]&alignCenterY",	 	// center vertically
				],
				gxChildViews: {
					newScriptBtn: {
						"+": "ButtonView",
						gxForePainter: "ControlFore.useMarkup.left",
						gxBackPainter: null,
						gxTitle: "<plusButton/> New Script",
						gxValueKey: "newScriptBtn",
					},
					deleteBtn: {
						"+": "ButtonView",
						gxForePainter: "ControlFore.useMarkup.left",
						gxBackPainter: null,
						gxTitle: "<minusButton/>",
						gxValueKey: "deleteScriptBtn",
						gxDisableOnNil: true,
						axTitle: "Delete selected scripts",
					}
				}
			}
		}
	},

		
	// MARK: built in scripts panel
		
	BuiltinScriptsPanel:
	{
		nsClass: "GXDrawView",
		axIsIgnored: true,
		gxShowOnKey: "builtinTabValue",
		gxLayout:
		[
			"V:|-0-[scriptsListScrollView]-0-[bottomBar(45)]-0-|",

			"H:|-0-[scriptsListScrollView]-1-|",
			"H:|-0-[builtinScriptsList]-0-|",
			"H:|-0-[bottomBar]-1-|",
		],
		gxChildViews:
		{
			scriptsListScrollView:
			{
				nsClass: "GXScrollView",
				gxBackColor: "SidebarBackColor2",
				gxVScrollbar: "ScrollBarView",	// vertical scroller only
				gxAddViewBelow: true,
				gxDocumentView:
				{
					nsClass: "GXListView",
					gxViewName: "builtinScriptsList",
					gxValueKey: "subModels",
					gxCopyValues: true,
					gxListItemView: "BuiltinScriptListItem",
					gxItemHeight: 34,
					gxInterItemHeight: 1,
					gxTopHeight: 5,
					gxBottomHeight: 6,
					axIsIgnored: false,
					axTitle: "Built-In Scripts List",
					axHelp: "List of all built-in scripts"
				}
			},
			bottomBar:
			{
				nsClass: "GXDrawView",
				gxBackPainter: {
					nsClass: "GXPainter",
					gxEdgeInsets: "-1, 0, -1, -1",
					gxFillColor: "SidebarBackColor2",
					gxFrameColor: "SidebarBackColor2.pressed",
				},
				gxLayout: [
					"H:|-13-[cloneScriptBtn(90)]",
					"H:[self]-(<=0)-[cloneScriptBtn]&alignCenterY",	// center vertically
				],
				gxChildViews: {
					cloneScriptBtn: {
						"+": "ButtonView",
						gxForePainter: "ControlFore.useMarkup.left",
						gxBackPainter: null,
						gxTitle: "<plusButton/> Duplicate",
						gxValueKey: "duplicateScriptBtn",
						axHelp: "Duplicates the selected built-in script as new user script you can edit."
					},
				}
			}
		}
	},

		
	// MARK: - side panel tabs

	ScriptsSidebarTabs:
	{
		nsClass: "GXDrawView",
		gxViewName: "sidebarTabs",
		axIsIgnored: true,
		axRoleDescription: "tab group",
		gxBackPainter: {
			nsClass: "GXPainter",
			gxEdgeInsets: "-2,-2,-2,0",
			gxFrameColor: "SidebarBackColor2.pressed",
			gxFillColor: "SidebarBackColor2",
		},
		gxLayout: [
			"H:|-40-[builtinTab]-40-[userTab(==builtinTab)]-40-|",

			"V:|-8-[builtinTab(27)]-0-[builtinLabel]&alignCenterX",
			"V:|-8-[userTab(27)]-0-[userLabel]&alignCenterX",
		],
		gxChildViews:
		{
			builtinTab: {
				"+": "ImageButtonView.showOn.script-tab-builtin",
				gxValueKey: "builtinTabValue",
				axTitle: "Built-In scripts",
				gxButtonType: "tab",
				axRoleDescription: "tab, 1 of 2",
				axHelp: "show built-in scripts",
			},
			builtinLabel: {
				"+": "TextButtonView.size11",
				gxValueKey: "builtinTabValue",
				gxDefaultDisplayValue: "Built-In Scripts",
				gxIntrinsicWidth: 85,
				axIsIgnored: true,
			},
			userTab: {
				"+": "ImageButtonView.showOn.script-tab-user",
				gxValueKey: "userTabValue",
				axTitle: "User scripts",
				gxButtonType: "tab",
				axRoleDescription: "tab, 2 of 2",
				axHelp: "show scripts you've created",
			},
			userLabel: {
				"+": "TextButtonView.size11",
				gxValueKey: "userTabValue",
				gxDefaultDisplayValue: "User Scripts",
				gxIntrinsicWidth: 75,
				axIsIgnored: true,
			},
		}
	},

		
	// --------------------------------------------------------
	// MARK: - scripts list items

	UserScriptListItem:
	{
		nsClass: "GXListItemView",
		gxSelectable: 2, // multiselect
		axIsIgnored: false,
		axRoleDescription: "User Script",
		axDescriptionKeyPath: "name",
		gxBackPainter: {
			"+": "ListItemBack",
			gxEdgeInsets: "5,0,0,0",
		},
		gxLateLayout:
		[
			"V:|-(-999)-[self(34)]",	// vertical position set by parent

			"H:[self(234)]",
			"H:|-12-[icon(16)]-8-[title]-4-|",
			"V:|-8-[icon(16)]",
			"V:|-5-[title(23)]",
		],
		gxChildViews:
		{
			icon: {
				"+": "ImageView.foreColor2.script-user",
			},
			title: {
				"+": "LabelView.foreColor1.size14.mediumWeight.left",
				gxValueKey: "name",
			},
		}
	},

	BuiltinScriptListItem:
	{
		nsClass: "GXListItemView",
		gxSelectable: 1, // single select
		gxIntrinsicHeight: 34,
		axIsIgnored: false,
		axRoleDescription: "Built In Script",
		axDescriptionKeyPath: "name",
		gxBackPainter: "ListItemBack.altRow",
		gxLateLayout:
		[
			"V:|-(-999)-[self(34)]",	// vertical position set by parent

			"H:[self(234)]",
			"H:|-12-[icon(16)]-8-[title]-10-|",
			"V:|-8-[icon(16)]",
			"V:|-5-[title(23)]",
		],
		gxChildViews:
		{
			icon: {
				"+": "ImageView.foreColor2.script-builtin",
			},
			title: {
				"+": "LabelView.foreColor1.size14.mediumWeight.left",
				gxValueKey: "name",
			},
		}
	},

	
})
